<?php
include "db.php";
session_start();

if (!isset($_SESSION["user_id"])) {
    header("Location: index.php");
    exit();
}

if (!isset($_GET['student_id'])) {
    header("Location: all-students.php?error=Student ID missing");
    exit();
}

$student_id = $_GET['student_id'];

try {
    $db = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Update the student's isCertIssued flag to 0 to approve certificate issuance
    $updateQuery = "UPDATE students SET isCertIssued = 0 WHERE student_id = :student_id";
    $updateStmt = $db->prepare($updateQuery);
    $updateStmt->bindParam(":student_id", $student_id);
    $updateStmt->execute();

    header("Location: all-students.php?success=Certificate approved for student successfully");
    exit();

} catch (PDOException $e) {
    header("Location: all-students.php?error=Error approving certificate: " . urlencode($e->getMessage()));
    exit();
}
?>
