<?php
// Database connection
include('panel/db.php');

$certificate = null;
$error_message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_name = trim($_POST['student_name'] ?? '');
    $father_name = trim($_POST['father_name'] ?? '');
    $dob = trim($_POST['date_of_birth'] ?? '');
    $certificate_number = trim($_POST['certificate_number'] ?? '');
    $dob_cert = trim($_POST['dob_cert'] ?? '');

    try {
        $db = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        if (!empty($student_name) && !empty($father_name) && !empty($dob)) {
            // Search by student name, father's name, and date of birth
            $query = "SELECT c.certificate_id, c.student_id, c.certificate_id AS certificate_number, s.student_name, s.date_of_birth, s.date_of_joining, s.mother_name, s.father_name, s.course_name
                      FROM certificates c
                      JOIN students s ON c.student_id = s.student_id
                      WHERE s.student_name = :student_name AND s.father_name = :father_name AND s.date_of_birth = :dob";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':student_name', $student_name);
            $stmt->bindParam(':father_name', $father_name);
            $stmt->bindParam(':dob', $dob);
            $stmt->execute();
            $certificate = $stmt->fetch(PDO::FETCH_ASSOC);
        } elseif (!empty($certificate_number) && !empty($dob_cert)) {
            // Search by certificate number and date of birth
            $query = "SELECT c.certificate_id, c.student_id, c.certificate_id AS certificate_number, s.student_name, s.date_of_birth, s.date_of_joining, s.mother_name, s.father_name, s.course_name
                      FROM certificates c
                      JOIN students s ON c.student_id = s.student_id
                      WHERE c.certificate_id = :certificate_number AND s.date_of_birth = :dob_cert";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':certificate_number', $certificate_number);
            $stmt->bindParam(':dob_cert', $dob_cert);
            $stmt->execute();
            $certificate = $stmt->fetch(PDO::FETCH_ASSOC);
        } else {
            $error_message = "Please provide either (Student Name, Father's Name, and Date of Birth) or (Certificate Number and Date of Birth).";
        }

        if (!$certificate && empty($error_message)) {
            $error_message = "No matching certificate found.";
        }
    } catch (PDOException $e) {
        $error_message = "Database error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Download Certificate</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />
    <style>
        .certificate-container {
            position: relative;
            width: 800px;
            max-width: 100%;
            margin: 30px auto;
            padding: 40px;
            background-image: url('https://youthpdorg.in/img/footer%20logo.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            border-radius: 15px;
            box-shadow: 0 0 15px rgba(0,0,0,0.3);
            color: #333;
            font-family: 'Arial', sans-serif;
        }
        .certificate-content {
            position: relative;
            background-color: rgba(255, 255, 255, 0.85);
            padding: 20px 40px;
            border-radius: 10px;
        }
        .certificate-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .certificate-header img {
            max-width: 150px;
            margin-bottom: 15px;
        }
        .certificate-header h1 {
            font-size: 28px;
            font-weight: bold;
            color: #2c3e50;
        }
        .certificate-table {
            width: 100%;
            margin-bottom: 30px;
        }
        .certificate-table th, .certificate-table td {
            padding: 10px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .certificate-table th {
            width: 40%;
            font-weight: 600;
            color: #34495e;
        }
        .btn-group {
            text-align: center;
            margin-bottom: 30px;
        }
        .btn-group button {
            margin: 0 10px;
        }
        @media print {
            body * {
                visibility: hidden;
            }
            .certificate-container, .certificate-container * {
                visibility: visible;
            }
            .certificate-container {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                margin: 0;
                box-shadow: none;
                border-radius: 0;
                background: none;
                padding: 0;
            }
            .btn-group {
                display: none;
            }
        }
    </style>
    <script>
        function printCertificate() {
            window.print();
        }
    </script>
</head>
<body>
<?php include 'header.php'; ?>
    <div class="container">
        <h2 class="text-center mt-4">Download Certificate</h2>
        <form method="POST" class="mb-4">
            <div class="form-row">
                <div class="form-group col-md-4">
                    <label for="student_name">Student Name</label>
                    <input type="text" class="form-control" id="student_name" name="student_name" value="<?php echo htmlspecialchars($_POST['student_name'] ?? ''); ?>">
                </div>
                <div class="form-group col-md-4">
                    <label for="father_name">Father's Name</label>
                    <input type="text" class="form-control" id="father_name" name="father_name" value="<?php echo htmlspecialchars($_POST['father_name'] ?? ''); ?>">
                </div>
                <div class="form-group col-md-4">
                    <label for="date_of_birth">Date of Birth</label>
                    <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" value="<?php echo htmlspecialchars($_POST['date_of_birth'] ?? ''); ?>">
                </div>
            </div>
            <p class="text-center my-3">OR</p>
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label for="certificate_number">Certificate Number</label>
                    <input type="text" class="form-control" id="certificate_number" name="certificate_number" value="<?php echo htmlspecialchars($_POST['certificate_number'] ?? ''); ?>">
                </div>
                <div class="form-group col-md-6">
                    <label for="dob_cert">Date of Birth</label>
                    <input type="date" class="form-control" id="dob_cert" name="dob_cert" value="<?php echo htmlspecialchars($_POST['dob_cert'] ?? ''); ?>">
                </div>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Download Certificate</button>
        </form>

        <?php if (!empty($error_message)): ?>
            <div class="alert alert-danger text-center" role="alert">
                <?php echo htmlspecialchars($error_message); ?>
            </div>
        <?php endif; ?>

        <?php if ($certificate): ?>
            <div class="certificate-container">
                <div class="certificate-content">
                    <div class="certificate-header">
                        <img src="https://youthpdorg.in/img/logo.png" alt="Logo">
                        <h1>Certificate of Completion</h1>
                    </div>
                    <table class="certificate-table">
                        <tr>
                            <th>Student ID</th>
                            <td><?php echo htmlspecialchars($certificate['student_id']); ?></td>
                        </tr>
                        <tr>
                            <th>Student Name</th>
                            <td><?php echo htmlspecialchars($certificate['student_name']); ?></td>
                        </tr>
                        <tr>
                            <th>Father's Name</th>
                            <td><?php echo htmlspecialchars($certificate['father_name']); ?></td>
                        </tr>
                        <tr>
                            <th>Mother's Name</th>
                            <td><?php echo htmlspecialchars($certificate['mother_name']); ?></td>
                        </tr>
                        <tr>
                            <th>Date of Birth</th>
                            <td><?php echo htmlspecialchars($certificate['date_of_birth']); ?></td>
                        </tr>
                        <tr>
                            <th>Date of Joining</th>
                            <td><?php echo htmlspecialchars($certificate['date_of_joining']); ?></td>
                        </tr>
                        <tr>
                            <th>Certificate Number</th>
                            <td><?php echo htmlspecialchars($certificate['certificate_number']); ?></td>
                        </tr>
                        <tr>
                            <th>Course Name</th>
                            <td><?php echo htmlspecialchars($certificate['course_name']); ?></td>
                        </tr>
                    </table>
                    <div class="btn-group">
                        <button class="btn btn-success" onclick="printCertificate()"><i class="fas fa-print"></i> Print</button>
                        <form method="POST" action="generate-certificate.php" target="_blank" style="display:inline;">
                            <input type="hidden" name="student_name" value="<?php echo htmlspecialchars($certificate['student_name']); ?>">
                            <input type="hidden" name="date_of_birth" value="<?php echo htmlspecialchars($certificate['date_of_birth']); ?>">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-download"></i> Download PDF</button>
                        </form>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
