<?php
header('Content-Type: application/json');
require_once 'connectiondb.php';

// Read JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['exam_id']) || !isset($input['exam_code'])) {
    echo json_encode(['valid' => false]);
    exit;
}

$exam_id = intval($input['exam_id']);
$exam_code = trim($input['exam_code']);

try {
    $stmt = $pdo->prepare("SELECT exam_code FROM exams WHERE id = ?");
    $stmt->execute([$exam_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && $row['exam_code'] === $exam_code) {
        echo json_encode(['valid' => true]);
    } else {
        echo json_encode(['valid' => false]);
    }
} catch (PDOException $e) {
    error_log("Database error in validate_exam_code.php: " . $e->getMessage());
    echo json_encode(['valid' => false]);
}
?>
