<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

require_once 'connectiondb.php';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Fetch all students
$stmtStudents = $pdo->query("SELECT id, student_id, name FROM students ORDER BY name");
$students = $stmtStudents->fetchAll(PDO::FETCH_ASSOC);

// Calculate attendance progress for each student
$attendance_progress = [];

foreach ($students as $student) {
    $student_id = $student['id'];

    // Count total attendance records for the student
    $stmtTotal = $pdo->prepare("SELECT COUNT(*) FROM attendance WHERE student_id = ?");
    $stmtTotal->execute([$student_id]);
    $total = (int)$stmtTotal->fetchColumn();

    // Count present days for the student
    $stmtPresent = $pdo->prepare("SELECT COUNT(*) FROM attendance WHERE student_id = ? AND status = 'present'");
    $stmtPresent->execute([$student_id]);
    $present = (int)$stmtPresent->fetchColumn();

    $percentage = ($total > 0) ? round(($present / $total) * 100, 2) : 0;

    $attendance_progress[$student_id] = [
        'total' => $total,
        'present' => $present,
        'percentage' => $percentage,
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Admin - Attendance Progress</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<?php include 'navbar.php'; ?>
<div class="container my-4">
    <h2>Student Attendance Progress</h2>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Student ID</th>
                <th>Name</th>
                <th>Attendance Progress</th>
                <th>Details</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($students as $student): 
                $progress = $attendance_progress[$student['id']] ?? ['percentage' => 0];
            ?>
            <tr>
                <td><?php echo htmlspecialchars($student['student_id']); ?></td>
                <td><?php echo htmlspecialchars($student['name']); ?></td>
                <td>
                    <div class="progress" style="height: 25px;">
                        <div class="progress-bar" role="progressbar" style="width: <?php echo $progress['percentage']; ?>%;" aria-valuenow="<?php echo $progress['percentage']; ?>" aria-valuemin="0" aria-valuemax="100">
                            <?php echo $progress['percentage']; ?>%
                        </div>
                    </div>
                </td>
                <td>
                    <a href="admin_attendance_chart.php?student_id=<?php echo urlencode($student['id']); ?>" class="btn btn-primary btn-sm">View Chart</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
