
<!-- Retrieve user information from the database -->
<?php include "db.php"; ?>

<?php
session_start();

// Check if the user is logged in
if (!isset($_SESSION["user_id"])) {
    header("Location: index.php");
    exit();
}

// Create connection
try {
    $db = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Retrieve all issued certificates with isCertIssued flag from students table
$query = "SELECT c.*, s.isCertIssued FROM certificates c JOIN students s ON c.student_id = s.student_id";
$stmt = $db->query($query);
$certificates = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>All Certificates</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <?php include "nav.php"; ?>
    <div class="container mt-5">
        <h2>All Certificates</h2>
        <?php if (count($certificates) > 0): ?>
            <table class="table">
                <thead>
                    <tr>
                        <th>Student ID</th>
                        <th>Student Name</th>
                        <th>Course Name</th>
                        <th>Certificate ID</th>
                        <th>Date of Joining</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($certificates as $certificate): ?>
                        <tr>
                            <td><?php echo $certificate["student_id"]; ?></td>
                            <td><?php echo $certificate["student_name"]; ?></td>
                            <td><?php echo $certificate["course_name"]; ?></td>
                            <td><?php echo $certificate[
                                "certificate_id"
                            ]; ?></td>
                            <td><?php echo $certificate[
                                "date_of_joining"
                            ]; ?></td>
                            <td>
                                <a href="delete-certificate.php?certificate_id=<?php echo $certificate['certificate_id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this certificate?')" <?php echo ($certificate['isCertIssued'] == 0) ? 'disabled' : ''; ?>>Delete</a>
                                <a href="edit-certificate.php?certificate_id=<?php echo $certificate['certificate_id']; ?>" class="btn btn-primary btn-sm ml-2" <?php echo ($certificate['isCertIssued'] == 0) ? 'disabled' : ''; ?>>Edit</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No certificates issued yet.</p>
        <?php endif; ?> 
    </div>

    <!-- jQuery, Popper.js, and Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
