<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

if (!isset($_GET['student_id']) || !is_numeric($_GET['student_id'])) {
    header('Location: manage_students.php');
    exit;
}

$student_id = (int)$_GET['student_id'];

require_once 'connectiondb.php';
;

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Delete the student and cascade delete related data due to foreign keys
    $stmt = $pdo->prepare("DELETE FROM students WHERE id = ?");
    $stmt->execute([$student_id]);

    header('Location: manage_students.php?msg=Student+deleted+successfully');
    exit;
} catch (PDOException $e) {
    die("Error deleting student: " . $e->getMessage());
}
?>
