-- MySQL dump 10.13  Distrib 8.0.40, for Linux (x86_64)
--
-- Host: localhost    Database: youthpdo_students_exams
-- ------------------------------------------------------
-- Server version	8.0.40

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `youthpdo_students_exams`
--


--
-- Table structure for table `admins`
--

DROP TABLE IF EXISTS `admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `password_hash` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `role` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'admin',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admins`
--

LOCK TABLES `admins` WRITE;
/*!40000 ALTER TABLE `admins` DISABLE KEYS */;
INSERT INTO `admins` (`id`, `username`, `password_hash`, `email`, `role`, `created_at`) VALUES (1,'gaurav@ypdoExam','Gaurav@2001YPDO','goluk924@gmail.com','admin','2025-04-28 15:55:08');
/*!40000 ALTER TABLE `admins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exams`
--

DROP TABLE IF EXISTS `exams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `exams` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_code` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `exam_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `duration` int DEFAULT NULL,
  `exam_month` varchar(10) COLLATE utf8mb4_general_ci NOT NULL,
  `allowed_attempts` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_code` (`exam_code`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exams`
--

LOCK TABLES `exams` WRITE;
/*!40000 ALTER TABLE `exams` DISABLE KEYS */;
INSERT INTO `exams` (`id`, `exam_code`, `exam_name`, `created_at`, `duration`, `exam_month`, `allowed_attempts`) VALUES (11,'2015','Mock Test','2025-04-29 13:22:37',15,'April',99),(12,'1306',' Shortcut Key Exam May 2025','2025-05-07 16:00:40',30,'May',1),(13,'2005','Notepad Exam May 2025','2025-05-12 15:41:32',30,'May',1),(14,'2025','Word Exam May 2025','2025-05-12 15:43:28',60,'May',1),(15,'5000','Excel Exam May 2025','2025-05-12 15:45:20',60,'May',1);
/*!40000 ALTER TABLE `exams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `question_id` int NOT NULL,
  `option_text` text COLLATE utf8mb4_general_ci NOT NULL,
  `is_correct` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `question_id` (`question_id`),
  CONSTRAINT `options_ibfk_1` FOREIGN KEY (`question_id`) REFERENCES `questions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1369 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
INSERT INTO `options` (`id`, `question_id`, `option_text`, `is_correct`) VALUES (689,173,'Win + F',0),(690,173,'Win + E',0),(691,173,'Win + R',1),(692,173,'Win + D',0),(693,174,'Ctrl + C',0),(694,174,'Ctrl + A',1),(695,174,'Ctrl + X',0),(696,174,'Ctrl + B',0),(697,175,'Ctrl + P',0),(698,175,'Ctrl + N',0),(699,175,'Ctrl + S',1),(700,175,'Ctrl + O',0),(701,176,'Ctrl + C',1),(702,176,'Ctrl + X',0),(703,176,'Ctrl + V',0),(704,176,'Ctrl + Z',0),(705,177,'Ctrl + X',0),(706,177,'Ctrl + C',0),(707,177,'Ctrl + V',1),(708,177,'Ctrl + Z',0),(709,178,'Ctrl + Shift + Esc',0),(710,178,'F5',0),(711,178,'Windows logo key + D',1),(712,178,'Windows logo key + C',0),(713,179,'Ctrl + X',0),(714,179,'Ctrl + Z',1),(715,179,'Ctrl + U',0),(716,179,'Ctrl + C',0),(717,180,'F1',0),(718,180,'F3',0),(719,180,'F2',1),(720,180,'F4',0),(721,181,'Ctrl+F5',0),(722,181,'Alt+F5',0),(723,181,'Alt+F4',1),(724,181,'Ctrl+F4',0),(725,182,'Ctrl+V',1),(726,182,'Alt+Ctrl+V',0),(727,182,'Ctrl+Shift+V',0),(728,182,'Ctrl+Shift+R',0),(729,183,'Windowkey + W',0),(730,183,'Windowkey + A',0),(731,183,'Windowkey + C',0),(732,183,'Windowkey + D',1),(733,184,'Ctrl+Shift+N',1),(734,184,'Alt+Shift+N',0),(735,184,'Ctrl+Alt+N',0),(736,184,'Alt+Shift+N',0),(737,185,'Windowkey+d',0),(738,185,'Windowkey+e',1),(739,185,'Windowkey+f',0),(740,185,'Windowkey+tab',0),(741,186,'Windowkey+M',0),(742,186,'Alt+L',0),(743,186,'Windowkey+L',1),(744,186,'Alt+F4',0),(745,187,'Alt+tab',1),(746,187,'Ctrl+tab',0),(747,187,'Alt+ctrl+tab',0),(748,187,'Alt+shift+tab',0),(749,188,'Ctrl + X',0),(750,188,'Ctrl + C',1),(751,188,'Ctrl + Z',0),(752,188,'Ctrl + V',0),(753,189,'Win + R',1),(754,189,'Ctrl + R',0),(755,189,'Alt + R',0),(756,189,'Shift + R',0),(757,190,'Lock the PC',1),(758,190,'Logout',0),(759,190,'Poweroff',0),(760,190,'Restart ',0),(761,191,'Win + Up Arrow',1),(762,191,'Win + Down Arrow',0),(763,191,'Win + M',0),(764,191,'Alt + Enter',0),(765,192,'Open Excel',0),(766,192,'Open File Explorer',1),(767,192,'Exit current program',0),(768,192,'Open browser',0),(769,193,'Ctrl + R',0),(770,193,'Ctrl + U',0),(771,193,'Ctrl + Z',1),(772,193,'Ctrl + Y',0),(773,194,'Win + Left Arrow',1),(774,194,'Alt + Left Arrow',0),(775,194,'Ctrl + Left Arrow',0),(776,194,'Shift + Left Arrow',0),(777,195,'Open Task View',1),(778,195,'Open File Explorer',0),(779,195,'Open Tabs',0),(780,195,'Close tasks',0),(781,196,'Open File Explorer',0),(782,196,'Launch Control Panel',0),(783,196,'Switch between open windows',1),(784,196,'Toggle taskbar',0),(785,197,'Save',0),(786,197,'Screenshot (Snipping Tool)',1),(787,197,'Sleep',0),(788,197,'Share',0),(789,198,'Ctrl + R',0),(790,198,'Ctrl + E',1),(791,198,'Ctrl + C',0),(792,198,'Ctrl + M',0),(793,199,'Refresh',1),(794,199,'Format',0),(795,199,'Find',0),(796,199,'Full screen',0),(797,200,'Open a file/document',1),(798,200,'Open Outlook',0),(799,200,'Optimize performance',0),(800,200,'Organize files',0),(801,201,'Downloads',0),(802,201,'Date settings',0),(803,201,'Desktop',1),(804,201,'Display options',0),(805,202,'TRUE',1),(806,202,'FALSE',0),(807,202,'-',0),(808,202,'-',0),(809,203,'TRUE',1),(810,203,'FALSE',0),(811,203,'-',0),(812,203,'-',0),(813,204,'TRUE',0),(814,204,'FALSE',1),(815,204,'-',0),(816,204,'-',0),(817,205,'TRUE',1),(818,205,'FALSE',0),(819,205,'-',0),(820,205,'-',0),(821,206,'TRUE',1),(822,206,'FALSE',0),(823,206,'-',0),(824,206,'-',0),(825,207,'TRUE',1),(826,207,'FALSE',0),(827,207,'-',0),(828,207,'-',0),(829,208,'File',0),(830,208,'Edit',0),(831,208,'Format',1),(832,208,'View',0),(833,209,'.rtf',0),(834,209,'.doc',0),(835,209,'.txt',1),(836,209,'.pdf',0),(837,210,'Ctrl + N',1),(838,210,'Ctrl + O',0),(839,210,'Ctrl + S',0),(840,210,'Ctrl + P',0),(841,211,'Ctrl + R',0),(842,211,'Ctrl + F',1),(843,211,'Ctrl + H',0),(844,211,'Alt + F',0),(845,212,'Ctrl + X',0),(846,212,'Ctrl + H',1),(847,212,'Ctrl + R',0),(848,212,'Ctrl + E',0),(849,213,'Word count',0),(850,213,'Line and column number',1),(851,213,'Font type',0),(852,213,'Time',0),(853,214,'F12',0),(854,214,'Ctrl + Shift + S',1),(855,214,'Alt + F4',0),(856,214,'Ctrl + Alt + S',0),(857,215,'System uptime',0),(858,215,'Last saved time',0),(859,215,'Current system date and time',1),(860,215,'Modified date',0),(861,216,'Only Courier New',0),(862,216,'Any installed font',1),(863,216,'Only monospaced fonts',0),(864,216,'Only system fonts',0),(865,217,'Ctrl + R',0),(866,217,'Check ',1),(867,217,'Ctrl + Shift + F',0),(868,217,'Alt + F3',0),(869,218,'Ctrl + =',0),(870,218,'Ctrl + Shift + + (Plus)',0),(871,218,'Ctrl + Alt  + + (Plus)',0),(872,218,'Ctrl + Mouse Wheel Up',1),(873,219,'Spell check',1),(874,219,'Word wrap',0),(875,219,'Basic text editing',0),(876,219,'Find and Replace',0),(877,220,'View',0),(878,220,'Format',1),(879,220,'Edit',0),(880,220,'Tools',0),(881,221,'Rich text documents',0),(882,221,'HTML and plain text files',1),(883,221,'Spreadsheet files',0),(884,221,'PDF files',0),(885,222,'Font',0),(886,222,'Print',0),(887,222,'Cut, Copy, Paste',1),(888,222,'Zoom',0),(889,223,'Wraps words in quotes',0),(890,223,'Moves long lines to the next line',1),(891,223,'Highlights long sentences',0),(892,223,'Changes font style',0),(893,224,'Ctrl + G',1),(894,224,'Ctrl + L',0),(895,224,'Ctrl + H',0),(896,224,'Ctrl + Shift + G',0),(897,225,'run notepad',0),(898,225,'notepad',1),(899,225,'open notepad',0),(900,225,'npd',0),(901,226,'Date and time',0),(902,226,'Line numbers',0),(903,226,'File name',1),(904,226,'Word count',0),(905,227,'Open',0),(906,227,'Save',0),(907,227,'Exit',0),(908,227,'Font',1),(909,228,'ASCII',0),(910,228,'ANSI',0),(911,228,'Unicode',0),(912,228,'UTF-8',1),(913,229,'File',0),(914,229,'View',1),(915,229,'Format',0),(916,229,'Edit',0),(917,230,'TRUE',1),(918,230,'FALSE',0),(919,230,'-',0),(920,230,'-',0),(921,231,'TRUE',0),(922,231,'FALSE',1),(923,231,'-',0),(924,231,'-',0),(925,232,'TRUE',0),(926,232,'FALSE',1),(927,232,'-',0),(928,232,'-',0),(929,233,'TRUE',1),(930,233,'FALSE',0),(931,233,'-',0),(932,233,'-',0),(933,234,'TRUE',0),(934,234,'FALSE',1),(935,234,'-',0),(936,234,'-',0),(937,235,'TRUE',0),(938,235,'FALSE',1),(939,235,'-',0),(940,235,'-',0),(941,236,'TRUE',1),(942,236,'FALSE',0),(943,236,'-',0),(944,236,'-',0),(945,237,'TRUE',0),(946,237,'FALSE',1),(947,237,'-',0),(948,237,'-',0),(949,238,'.txt',0),(950,238,'.docx',0),(951,238,'.rtf',1),(952,238,'.pdf',0),(953,239,'Font group',1),(954,239,'Paragraph group',0),(955,239,'Clipboard group',0),(956,239,'Review group',0),(957,240,'Ctrl + H',0),(958,240,'Ctrl + L',0),(959,240,'Ctrl + K',1),(960,240,'Ctrl + Shift + K',0),(961,241,'Ctrl + F',1),(962,241,'Ctrl + N',0),(963,241,'Ctrl + G',0),(964,241,'Ctrl + H',0),(965,242,'Format Menu',0),(966,242,'Edit Menu',0),(967,242,'Not available',1),(968,242,'Home Tab',0),(969,243,'Design',1),(970,243,'Layout',0),(971,243,'View',0),(972,243,'Insert',0),(973,244,'Align left',0),(974,244,'Align right',0),(975,244,'Center align',1),(976,244,'Justify',0),(977,245,'Align Group',0),(978,245,'Paragraph Menu',0),(979,245,'No such option',0),(980,245,'Home Tab',1),(981,246,'Top left',0),(982,246,'Top right',0),(983,246,'Bottom left',0),(984,246,'Bottom right',1),(985,247,'Design',1),(986,247,'Insert',0),(987,247,'Layout',0),(988,247,'Home',0),(989,248,'Paragraph',1),(990,248,'Font',0),(991,248,'Styles',0),(992,248,'Clipboard',0),(993,249,'Insert',1),(994,249,'Design',0),(995,249,'Home',0),(996,249,'View',0),(997,250,'Insert',0),(998,250,'Home',1),(999,250,'View',0),(1000,250,'Review',0),(1001,251,'Ctrl + >',0),(1002,251,'Ctrl + Shift + >',1),(1003,251,'Alt + >',0),(1004,251,'Shift + >',0),(1005,252,'Landscape',0),(1006,252,'Portrait',1),(1007,252,'Custom',0),(1008,252,'Book Fold',0),(1009,253,'Insert > Symbol',1),(1010,253,'Home > Font',0),(1011,253,'Layout > Breaks',0),(1012,253,'References > Insert',0),(1013,254,'Review',0),(1014,254,'References',1),(1015,254,'Insert',0),(1016,254,'View',0),(1017,255,'Insert > Page Number',1),(1018,255,'Layout > Page Number',0),(1019,255,'Design > Page Number',0),(1020,255,'View > Page Number',0),(1021,256,'Ctrl + S',0),(1022,256,'Ctrl + A',1),(1023,256,'Ctrl + D',0),(1024,256,'Ctrl + F',0),(1025,257,'Font change',0),(1026,257,'Spell check',1),(1027,257,'Bold',0),(1028,257,'Picture insert',0),(1029,258,'Insert',0),(1030,258,'Design',0),(1031,258,'Review',0),(1032,258,'References',1),(1033,259,'Insert',0),(1034,259,'Design',1),(1035,259,'Layout',0),(1036,259,'View',0),(1037,260,'Mail Merge',1),(1038,260,'SmartArt',0),(1039,260,'Formulas',0),(1040,260,'Charts',0),(1041,261,'Styles group',1),(1042,261,'Font group',0),(1043,261,'Paragraph group',0),(1044,261,'Clipboard group',0),(1045,262,'Table',0),(1046,262,'Chart',1),(1047,262,'SmartArt',0),(1048,262,'Graph',0),(1049,263,'Left',0),(1050,263,'Center',0),(1051,263,'Justify',0),(1052,263,'Middle',1),(1053,264,'Ctrl + Z',0),(1054,264,'Ctrl + Y',1),(1055,264,'Ctrl + X',0),(1056,264,'Ctrl + Shift + Z',0),(1057,265,'Home',1),(1058,265,'Insert',0),(1059,265,'View',0),(1060,265,'Review',0),(1061,266,'Ctrl + K',1),(1062,266,'Ctrl + H',0),(1063,266,'Ctrl + L',0),(1064,266,'Ctrl + J',0),(1065,267,'F12',1),(1066,267,'Ctrl + S',0),(1067,267,'Alt + F4',0),(1068,267,'Shift + F12',0),(1069,268,'Mail Merge',1),(1070,268,'References',0),(1071,268,'Insert',0),(1072,268,'Layout',0),(1073,269,'Insert',0),(1074,269,'Design',0),(1075,269,'Layout',1),(1076,269,'View',0),(1077,270,'Insert',0),(1078,270,'Review',1),(1079,270,'View',0),(1080,270,'Layout',0),(1081,271,'Insert',1),(1082,271,'Layout',0),(1083,271,'Home',0),(1084,271,'Design',0),(1085,272,'Font',1),(1086,272,'Paragraph',0),(1087,272,'Clipboard',0),(1088,272,'Editing',0),(1089,273,'Insert > Picture',1),(1090,273,'Home > Image',0),(1091,273,'Edit > Image',0),(1092,273,'View > Picture',0),(1093,274,'Ctrl + Shift + <',1),(1094,274,'Ctrl + Shift + >',0),(1095,274,'Ctrl + <',0),(1096,274,'Ctrl + >',0),(1097,275,'Decrease font',0),(1098,275,'Increase font',1),(1099,275,'Bold',0),(1100,275,'Underline',0),(1101,276,'Ctrl + P',0),(1102,276,'Ctrl + Enter',1),(1103,276,'Ctrl + Shift',0),(1104,276,'Ctrl + M',0),(1105,277,'Left align',0),(1106,277,'Right align',0),(1107,277,'Center align',1),(1108,277,'Justify',0),(1109,278,'Ctrl + L',0),(1110,278,'Ctrl + R',0),(1111,278,'Ctrl + J',1),(1112,278,'Ctrl + E',0),(1113,279,'Right align',0),(1114,279,'Center align',0),(1115,279,'Left align',1),(1116,279,'Justify',0),(1117,280,'Ctrl + R',1),(1118,280,'Ctrl + E',0),(1119,280,'Ctrl + J',0),(1120,280,'Ctrl + L',0),(1121,281,'Insert',1),(1122,281,'Layout',0),(1123,281,'Design',0),(1124,281,'View',0),(1125,282,'Print Layout',0),(1126,282,'Read Mode',1),(1127,282,'Web Layout',0),(1128,282,'Outline',0),(1129,283,'TRUE',0),(1130,283,'FALSE',1),(1131,283,' ',0),(1132,283,' ',0),(1133,284,'TRUE',0),(1134,284,'FALSE',1),(1135,284,' ',0),(1136,284,' ',0),(1137,285,'TRUE',1),(1138,285,'FALSE',0),(1139,285,' ',0),(1140,285,' ',0),(1141,286,'TRUE',0),(1142,286,'FALSE',1),(1143,286,' ',0),(1144,286,' ',0),(1145,287,'TRUE',0),(1146,287,'FALSE',1),(1147,287,' ',0),(1148,287,' ',0),(1149,288,'TRUE',1),(1150,288,'FALSE',0),(1151,288,' ',0),(1152,288,' ',0),(1153,289,'TRUE',0),(1154,289,'FALSE',1),(1155,289,' ',0),(1156,289,' ',0),(1157,290,'TRUE',1),(1158,290,'FALSE',0),(1159,290,' ',0),(1160,290,' ',0),(1161,291,'TRUE',0),(1162,291,'FALSE',1),(1163,291,' ',0),(1164,291,' ',0),(1165,292,'TRUE',1),(1166,292,'FALSE',0),(1167,292,' ',0),(1168,292,' ',0),(1169,293,'TRUE',0),(1170,293,'FALSE',1),(1171,293,' ',0),(1172,293,' ',0),(1173,294,'TRUE',1),(1174,294,'FALSE',0),(1175,294,' ',0),(1176,294,' ',0),(1177,295,'TRUE',1),(1178,295,'FALSE',0),(1179,295,' ',0),(1180,295,' ',0),(1181,296,'TRUE',0),(1182,296,'FALSE',1),(1183,296,' ',0),(1184,296,' ',0),(1185,297,'TRUE',1),(1186,297,'FALSE',0),(1187,297,' ',0),(1188,297,' ',0),(1189,298,'MIN()',0),(1190,298,'MAX()',1),(1191,298,'AVERAGE()',0),(1192,298,'COUNT()',0),(1193,299,'Counts all cells',0),(1194,299,'Counts numerical cells only',1),(1195,299,'Counts text cells only',0),(1196,299,'Counts all non-empty cells',0),(1197,300,'COUNT()',0),(1198,300,'COUNTA()',0),(1199,300,'COUNTIF()',1),(1200,300,'AVERAGE()',0),(1201,301,'IF(condition, value_if_true, value_if_false)',1),(1202,301,'IF(value_if_true, condition, value_if_false)',0),(1203,301,'IF(value_if_false, value_if_true, condition)',0),(1204,301,'IF(condition, value_if_false, value_if_true)',0),(1205,302,'IF(A1>10, \'Over 10\', IF(A1<5, \'Under 5\', \'Between 5 and 10\'))',1),(1206,302,'IF(A1>10, \'Over 10\' IF(A1<5, \'Under 5\', \'Between 5 and 10\'))',0),(1207,302,'IF(A1>10, \'Over 10\', [A1<5], \'Under 5\', \'Between 5 and 10\')',0),(1208,302,'IF(A1>10: \'Over 10\', A1<5: \'Under 5\', \'Between 5 and 10\')',0),(1209,303,'Count all cells',0),(1210,303,'Count cells based on one criterion',1),(1211,303,'Count cells based on multiple criteria',0),(1212,303,'Count non-empty cells',0),(1213,304,'Counts only blank cells',0),(1214,304,'Counts only numeric cells',0),(1215,304,'Counts all non-empty cells',1),(1216,304,'Counts only text cells',0),(1217,305,'10',0),(1218,305,'2',0),(1219,305,'3',1),(1220,305,'5',0),(1221,306,'The minimum of a set of values',1),(1222,306,'The average of a set of values',0),(1223,306,'The total of a set of values',0),(1224,306,'The maximum of a set of values',0),(1225,307,'Home > Styles > Conditional Format',0),(1226,307,'Home > Format > Conditional Formatting',0),(1227,307,'Home > Conditional Formatting',1),(1228,307,'Home > Styles > Conditional Formatting Rules',0),(1229,308,'High',0),(1230,308,'Low',1),(1231,308,'10',0),(1232,308,'5',0),(1233,309,'Returns the average value',0),(1234,309,'Returns the highest value',1),(1235,309,'Returns the lowest value',0),(1236,309,'Returns the sum of the values',0),(1237,310,'2',0),(1238,310,'10',0),(1239,310,'Both A and B',1),(1240,310,' =NUMBER(B1:B10)',0),(1241,311,'Counts all cells',0),(1242,311,'Counts cells greater than 5',1),(1243,311,'Counts empty cells',0),(1244,311,'Sums values greater than 5',0),(1245,312,'14',0),(1246,312,'36',1),(1247,312,'48',0),(1248,312,'26',0),(1249,313,'Cell styles',0),(1250,313,'Data validation',0),(1251,313,'Conditional formatting',1),(1252,313,'Number formatting',0),(1253,314,'0',1),(1254,314,'0',0),(1255,314,'#DIV/0!',0),(1256,314,'0',0),(1257,315,'TRUE',1),(1258,315,'1',0),(1259,315,'\'False\'',0),(1260,315,'#Value',0),(1261,316,'AND()',0),(1262,316,'OR()',0),(1263,316,'IF()',0),(1264,316,'AVERAGE()',1),(1265,317,'Yes',1),(1266,317,'No',0),(1267,317,'10',0),(1268,317,'0',0),(1269,318,'The count of the word \'Apple\'',1),(1270,318,'The count of cells that are empty',0),(1271,318,'The sum of values greater than Apple',0),(1272,318,'A text error',0),(1273,319,'SUM()',0),(1274,319,'IF(AND())',1),(1275,319,'VLOOKUP()',0),(1276,319,'COUNTIF()',0),(1277,320,'2',0),(1278,320,'5',0),(1279,320,'3',1),(1280,320,'4',0),(1281,321,'The smallest number',0),(1282,321,'The largest number',1),(1283,321,'The average number',0),(1284,321,'A specified count',0),(1285,322,'Data bars',0),(1286,322,'Color scales',0),(1287,322,'Borders',0),(1288,322,'Cell height',1),(1289,323,'10 if A1 is 5',1),(1290,323,'5 if A1 is not 5',0),(1291,323,'A1+5 if A1 is 5',0),(1292,323,'A1 if it\'s between 1 and 10',0),(1293,324,'A2',0),(1294,324,'B1',0),(1295,324,'C1',0),(1296,324,'B2',1),(1297,325,'LOOKUP(lookup_value, lookup_vector, [result_vector])',1),(1298,325,'LOOKUP(lookup_vector, lookup_value, [result_vector])',0),(1299,325,'LOOKUP(result_vector, lookup_value, lookup_vector)',0),(1300,325,'LOOKUP(lookup_value, result_vector, [lookup_vector])',0),(1301,326,'AVERAGE(value1, value2, ...)',0),(1302,326,'AVERAGE(range)',0),(1303,326,'AVERAGE(value1:value2)',0),(1304,326,'All of the above',1),(1305,327,'LOOKUP',0),(1306,327,'VLOOKUP',0),(1307,327,'HLOOKUP',0),(1308,327,'CLOOKUP',1),(1309,328,'\'Low\'',0),(1310,328,'\'High\'',0),(1311,328,'\'Medium\'',1),(1312,328,'Error',0),(1313,329,'Counts numbers smaller than 10',1),(1314,329,'Counts numbers greater than 10',0),(1315,329,'Counts exactly the number 10',0),(1316,329,'Counts numbers less than or equal to 10',0),(1317,330,'OR()',0),(1318,330,'AND()',1),(1319,330,'NOT()',0),(1320,330,'IF()',0),(1321,331,'5.33',1),(1322,331,'4',0),(1323,331,'6',0),(1324,331,'8',0),(1325,332,'To count physical rows',0),(1326,332,'To count the number of cells that contain numbers',1),(1327,332,'To count the number of empty cells',0),(1328,332,'To count text cells only',0),(1329,333,'HLOOKUP(lookup_value, table_array, col_index_num, [range_lookup])',0),(1330,333,'HLOOKUP(table_array, lookup_value, row_index_num, [range_lookup])',0),(1331,333,'HLOOKUP(lookup_value, table_array, row_index_num, [range_lookup])',1),(1332,333,'HLOOKUP(row_index_num, lookup_value, table_array, [range_lookup])',0),(1333,334,'4',1),(1334,334,'3',0),(1335,334,'1',0),(1336,334,'5',0),(1337,335,'They can only have two conditions',0),(1338,335,'You can nest up to 64 IF functions in one formula',1),(1339,335,'Only one IF function is allowed per formula',0),(1340,335,'Nested IF functions can only be used with numbers',0),(1341,336,'Yes',0),(1342,336,'No',1),(1343,336,'Error',0),(1344,336,'FALSE',0),(1345,337,'Pass',0),(1346,337,'Fail',1),(1347,337,'Error',0),(1348,337,'TRUE',0),(1349,338,'VLOOKUP()',1),(1350,338,'HLOOKUP()',0),(1351,338,'INDEX()',0),(1352,338,'MATCH()',0),(1353,339,'IF()',1),(1354,339,'AND()',0),(1355,339,'OR()',0),(1356,339,'NOT()',0),(1357,340,'Counts all non-empty cells',0),(1358,340,'Counts all cells',0),(1359,340,'Counts empty cells',1),(1360,340,'Counts text cells',0),(1361,341,'VLOOKUP(lookup_value, table_array, col_index_num, [range_lookup])',1),(1362,341,'VLOOKUP(lookup_value, row_array, col_index_num, [range_lookup])',0),(1363,341,'VLOOKUP(table_array, lookup_value, col_index_num, [range_lookup])',0),(1364,341,'VLOOKUP(lookup_value, table_array, row_index_num, [range_lookup])',0),(1365,342,'Returns 0',0),(1366,342,'Returns #DIV/0! error',1),(1367,342,'Returns #N/A error',0),(1368,342,'Returns an infinite number',0);
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `questions`
--

DROP TABLE IF EXISTS `questions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `questions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_id` int NOT NULL,
  `question_text` text COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `questions_ibfk_1` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `questions`
--

LOCK TABLES `questions` WRITE;
/*!40000 ALTER TABLE `questions` DISABLE KEYS */;
INSERT INTO `questions` (`id`, `exam_id`, `question_text`) VALUES (173,11,'Which shortcut key opens the Run dialog box in Windows?'),(174,11,'Which shortcut key selects all text in a Word document?'),(175,11,'Which shortcut key saves the current document in Word?'),(176,11,'Which shortcut key copies selected text?'),(177,11,'Which shortcut key pastes copied content?'),(178,12,'Which of the following keyboard shortcuts is used to minimize all applications and display desktop in Windows operating system?'),(179,12,'Undo is similar to _______.'),(180,12,'Which function key is used for renaming file or folder ?'),(181,12,'Which shortcut key will shutdown your computer?'),(182,12,'Which is the shortcut key to paste?'),(183,12,'Which is the shortcut key to display the Desktop when you have other files open?'),(184,12,'When you are in File explorer how will you create a New Folder with shortcut key?'),(185,12,'What is the shortcut key to open File explorer window?'),(186,12,'What is the shortcut key to lock your desktop?'),(187,12,'What is the shortcut key to Switch Program?'),(188,12,'Which shortcut is used to copy selected text or files?'),(189,12,'Which shortcut is used to open the Run dialog box?'),(190,12,'What is the function of Win + L?'),(191,12,'Which shortcut maximizes the active window?'),(192,12,'What does Win + E do?'),(193,12,'Which shortcut is used to undo an action?'),(194,12,'Which shortcut snaps a window to the left side of the screen?'),(195,12,'Win + Tab is used to:'),(196,12,'Alt + Tab allows you to:'),(197,12,'Win + Shift + S is used for:'),(198,12,'Shortcut for Center-aligning text:'),(199,12,'F5 in File Explorer or browser:'),(200,12,'Ctrl + O is used to:'),(201,12,'Win + D shows:'),(202,12,'Win + L locks the computer. True or False?'),(203,12,'Win + M minimizes all windows. True or False?'),(204,12,'Ctrl + X copies the selected content to the clipboard.'),(205,12,'Ctrl + Shift + N creates a new folder in File Explorer.'),(206,12,'Alt + F4 closes the current window or app.'),(207,12,'F5 refreshes the current webpage or window.'),(208,13,'Which menu contains the \'Word Wrap\' option in Notepad?'),(209,13,'What is the default file extension for files saved in Notepad?'),(210,13,'Which shortcut is used to create a new document in Notepad?'),(211,13,'Which shortcut opens the \'Find\' dialog in Notepad?'),(212,13,'Which of the following can be used to replace text in Notepad?'),(213,13,'The status bar in Notepad shows which of the following?'),(214,13,'To open the \'Save As\' dialog box in Notepad, you use:'),(215,13,'What does the \'Time/Date\' option insert into the Notepad file?'),(216,13,'Which font types can be set in Notepad?'),(217,13,'Which of the following allows you to search for a word in reverse direction?'),(218,13,'To zoom in the text in Notepad, which shortcut do you use?'),(219,13,'Which of the following is NOT a feature of Notepad?'),(220,13,'Which menu allows you to change the font in Notepad?'),(221,13,'Notepad is best suited for which type of file editing?'),(222,13,'The \'Edit\' menu in Notepad includes which of the following?'),(223,13,'When \'Word Wrap\' is enabled, what does it do?'),(224,13,'To open the '),(225,13,'Which of the following is the correct path to open Notepad using the Run dialog?'),(226,13,'The Notepad title bar displays which of the following by default?'),(227,13,'Which of the following is NOT found under the File menu in Notepad?'),(228,13,'What is the default encoding used by Notepad in Windows 10?'),(229,13,'In Notepad, the status bar is enabled through which menu?'),(230,13,'You can zoom text in Notepad using Ctrl + Mouse Wheel.'),(231,13,'You can drag and drop text inside Notepad to move it.'),(232,13,'The \'Format\' menu includes options for font and zoom.'),(233,13,'Notepad supports printing directly from the application.'),(234,13,'You can change background color in Notepad.'),(235,13,'Ctrl + N opens a new Notepad window.'),(236,13,'You can change font type and size in Notepad.'),(237,13,'You can embed images directly into a Notepad document.'),(238,14,'What is the default extension of WordPad documents?'),(239,14,'Which option is used to change text color?'),(240,14,'In MS Word, how do you insert a hyperlink?'),(241,14,'Which shortcut opens the Navigation Pane?'),(242,14,'In WordPad, which option changes text case?'),(243,14,'Which tab in MS Word contains the Themes option?'),(244,14,'What does Ctrl + E do in WordPad?'),(245,14,'In WordPad, which command is used to align text?'),(246,14,'The Zoom slider in MS Word is located at:'),(247,14,'Which tab is used to add page borders?'),(248,14,'Which group contains the \'Bullets\' option?'),(249,14,'Which tab contains options to add cover page?'),(250,14,'Where is the clipboard task pane located?'),(251,14,'How to increase font size using a shortcut?'),(252,14,'The default orientation in MS Word is:'),(253,14,'Which of the following commands is used to insert symbols?'),(254,14,'To insert a footnote in MS Word, go to:'),(255,14,'Which option allows numbering pages in MS Word?'),(256,14,'Shortcut to select the entire document?'),(257,14,'Which of these is NOT available in WordPad?'),(258,14,'Which option in MS Word allows you to add references?'),(259,14,'In MS Word, you can apply a watermark from which tab?'),(260,14,'Which MS Word feature allows you to combine address data with a letter?'),(261,14,'Which of the following lets you apply predefined styles in MS Word?'),(262,14,'In MS Word, what is used to organize and display data graphically?'),(263,14,'Which of the following is not a text alignment option in MS Word?'),(264,14,'Which key combination is used to redo an action in MS Word?'),(265,14,'The clipboard group appears under which tab in MS Word?'),(266,14,'Which key is used to insert a hyperlink in MS Word?'),(267,14,'Which shortcut key opens the Save As dialog box in MS Word?'),(268,14,'Which feature allows creating envelopes in MS Word?'),(269,14,'Which tab includes Margins, Orientation and Size?'),(270,14,'Where is Word Count located in MS Word?'),(271,14,'Which tab includes options for Header and Footer?'),(272,14,'Which group contains the option to change font size?'),(273,14,'How can you insert a picture in WordPad?'),(274,14,'To decrease font size incrementally, use:'),(275,14,'What does Ctrl + Shift + > do in MS Word?'),(276,14,'Which key is used to insert a page break?'),(277,14,'What is the function of Ctrl + E in MS Word?'),(278,14,'To justify text in MS Word, which shortcut is used?'),(279,14,'What does Ctrl + L do in MS Word?'),(280,14,'To right-align text, which shortcut is used?'),(281,14,'To insert a table, you should go to which tab?'),(282,14,'Which layout view is best for reading documents?'),(283,14,'You can insert tables in WordPad.'),(284,14,'WordPad has a spell check feature.'),(285,14,'WordPad can open .rtf files.'),(286,14,'WordPad is more advanced than MS Word.'),(287,14,'You can use WordPad to create hyperlinks.'),(288,14,'WordPad allows printing of documents.'),(289,14,'WordPad supports adding headers and footers.'),(290,14,'You can save documents as .txt files in WordPad.'),(291,14,'WordPad has a Word Count feature.'),(292,14,'The default file extension for MS Word documents is .docx.'),(293,14,'MS Word cannot check for spelling and grammar errors.'),(294,14,'Headers and footers can be added in MS Word.'),(295,14,'WordArt is a feature available in MS Word for decorative text.'),(296,14,'MS Word does not support printing documents.'),(297,14,'You can use the ruler to adjust margins in MS Word.'),(298,15,'What function would you use to find the maximum value in a range?'),(299,15,'What does the COUNT function do?'),(300,15,'Which function would you use to count how many cells meet a specific condition?'),(301,15,'What is the correct syntax for the IF function?'),(302,15,'Which of the following is a valid nested IF function?'),(303,15,'What is the purpose of COUNTIF?'),(304,15,'What does the COUNTA function do?'),(305,15,'In Excel, what would the formula =AVERAGE(1, 2, 3, 4, 5) return?'),(306,15,'What does the MIN function return?'),(307,15,'Which option correctly applies Conditional Formatting?'),(308,15,'What would the formula =IF(A1<10, \'Low\', \'High\') return if A1=5?'),(309,15,'What does the formula =MAX(A1:A5) do?'),(310,15,'Which formula is valid for counting the number of entries in range B1:B10?'),(311,15,'In Excel, what does the formula =COUNTIF(A1:A10, \'>5\') do?'),(312,15,'What is the result of the formula =PRODUCT(2, 4, 6)?'),(313,15,'What type of formatting can be applied conditionally based on cell values?'),(314,15,'Which formula is used to find the minimum value?'),(315,15,'What will the formula =IF(1=1, \'True\', \'False\') display?'),(316,15,'Which of the following is NOT a logical function in Excel?'),(317,15,'If the function =IF(A1=10, \'Yes\', \'No\') is in cell A2 and A1 is 10, what will A2 display?'),(318,15,'What will the following formula return? =COUNTIF(B1:B10, \'Apple\')'),(319,15,'Which function can be used alongside IF for multiple criteria?'),(320,15,'What is the result of =COUNT(A1:A5) if A1=1, A2=2, A3=\'\', A4=\'Hello\', A5=5?'),(321,15,'What will the MAX function return?'),(322,15,'When using Conditional Formatting, which of the following options can you NOT apply?'),(323,15,'What will the following formula return: =IF(A1=5, 10, A1+5)?'),(324,15,'A student scored 68 marks out of 100 in a subject. Using the grading system below, what grade would the student receive? =IF(M4<33,\'f\',IF(AND(M4>=33,M4<=40),\'d\',IF(AND(M4>41,M4<=50),\'c2\',IF(AND(M4>=51,M4<=60),\'c1\',IF(AND(M4>=61,M4<=70),\'b2\',IF(AND(M4>=71,M4<=80),\'b1\',IF(AND(M4>=81,M4<=90),\'a2\',IF(AND(M4>=91,M4<=100),\'a1\',\'invalid\'))))))))'),(325,15,'What is the correct syntax for the LOOKUP function?'),(326,15,'What is the correct syntax for the AVERAGE function?'),(327,15,'Which of the following is NOT a type of LOOKUP function in Excel?'),(328,15,'In the IF formula =IF(A1 < 5, \'Low\', IF(A1 > 10, \'High\', \'Medium\')), what does it return if A1 equals 7?'),(329,15,'What does the COUNTIF formula =COUNTIF(A1:A10, \'<10\') do?'),(330,15,'Which function checks multiple criteria and returns TRUE only if all are true?'),(331,15,'If the formula =AVERAGE(2, 4) returns 3, what will =AVERAGE(2, 4, 10) return?'),(332,15,'What is the primary use of the COUNT function?'),(333,15,'What is the correct syntax for the HLOOKUP function?'),(334,15,'What is displayed if =MAX(A1:A5) where A1=3, A2=1, A3=4, A4=1, A5=2?'),(335,15,'Which is a correct statement about nested IF functions?'),(336,15,'What is the result of the formula =IF(AND(A1=10, B1=20), \'Yes\', \'No\') when A1=10 and B1=15?'),(337,15,'What will the formula =IF(A1>5, \'Pass\', \'Fail\') return if A1=3?'),(338,15,'Which function would you use to look up a value in the first column of a table and return a value in the same row from another column?'),(339,15,'Which Excel function checks if a condition is met, and returns one value if TRUE, and another if FALSE?'),(340,15,'What does the formula =COUNTBLANK(A1:A10) do?'),(341,15,'What is the correct syntax for the VLOOKUP function?'),(342,15,'What happens if you enter =1/0 in a cell in Excel?');
/*!40000 ALTER TABLE `questions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `student_answers`
--

DROP TABLE IF EXISTS `student_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `student_answers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` int NOT NULL,
  `question_id` int NOT NULL,
  `selected_option_id` int NOT NULL,
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `question_id` (`question_id`),
  KEY `selected_option_id` (`selected_option_id`),
  CONSTRAINT `student_answers_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `student_answers_ibfk_2` FOREIGN KEY (`question_id`) REFERENCES `questions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `student_answers_ibfk_3` FOREIGN KEY (`selected_option_id`) REFERENCES `options` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=621 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `student_answers`
--

LOCK TABLES `student_answers` WRITE;
/*!40000 ALTER TABLE `student_answers` DISABLE KEYS */;
INSERT INTO `student_answers` (`id`, `student_id`, `question_id`, `selected_option_id`, `submitted_at`) VALUES (364,35,174,694,'2025-05-07 05:28:52'),(365,35,176,701,'2025-05-07 05:28:52'),(366,35,177,707,'2025-05-07 05:28:52'),(367,35,175,699,'2025-05-07 05:28:52'),(368,35,173,691,'2025-05-07 05:28:52'),(414,34,173,691,'2025-05-07 05:41:21'),(415,34,176,701,'2025-05-07 05:41:21'),(416,34,175,699,'2025-05-07 05:41:21'),(417,34,177,707,'2025-05-07 05:41:21'),(418,34,174,694,'2025-05-07 05:41:21'),(565,18,173,691,'2025-05-11 17:45:35'),(566,18,174,694,'2025-05-11 17:45:35'),(567,18,177,706,'2025-05-11 17:45:35'),(568,18,176,701,'2025-05-11 17:45:35'),(569,18,175,699,'2025-05-11 17:45:35'),(570,18,181,723,'2025-05-12 04:42:38'),(571,18,202,805,'2025-05-12 04:42:38'),(572,18,204,814,'2025-05-12 04:42:38'),(573,18,200,797,'2025-05-12 04:42:38'),(574,18,185,738,'2025-05-12 04:42:38'),(575,18,205,817,'2025-05-12 04:42:38'),(576,18,207,825,'2025-05-12 04:42:38'),(577,18,192,766,'2025-05-12 04:42:38'),(578,18,193,771,'2025-05-12 04:42:38'),(579,18,188,750,'2025-05-12 04:42:38'),(580,18,180,719,'2025-05-12 04:42:38'),(581,18,199,793,'2025-05-12 04:42:38'),(582,18,206,821,'2025-05-12 04:42:38'),(583,18,197,786,'2025-05-12 04:42:38'),(584,18,187,745,'2025-05-12 04:42:38'),(585,18,198,790,'2025-05-12 04:42:38'),(586,18,191,761,'2025-05-12 04:42:38'),(587,18,190,757,'2025-05-12 04:42:38'),(588,18,184,733,'2025-05-12 04:42:38'),(589,18,182,725,'2025-05-12 04:42:38'),(590,18,195,777,'2025-05-12 04:42:38'),(591,18,186,743,'2025-05-12 04:42:38'),(592,18,201,803,'2025-05-12 04:42:38'),(593,18,194,773,'2025-05-12 04:42:38'),(594,18,178,711,'2025-05-12 04:42:38'),(595,18,183,732,'2025-05-12 04:42:38'),(596,18,196,783,'2025-05-12 04:42:38'),(597,18,179,714,'2025-05-12 04:42:38'),(598,18,189,753,'2025-05-12 04:42:38'),(599,18,203,809,'2025-05-12 04:42:38'),(600,32,175,699,'2025-05-12 07:31:11'),(601,32,177,707,'2025-05-12 07:31:11'),(602,32,173,691,'2025-05-12 07:31:11'),(603,32,174,694,'2025-05-12 07:31:11'),(604,32,176,701,'2025-05-12 07:31:11'),(610,31,173,691,'2025-05-12 07:36:39'),(611,33,173,691,'2025-05-12 07:40:09'),(612,33,175,699,'2025-05-12 07:40:09'),(613,33,176,701,'2025-05-12 07:40:09'),(614,33,177,707,'2025-05-12 07:40:09'),(615,33,174,694,'2025-05-12 07:40:09'),(616,30,173,691,'2025-05-12 13:00:15'),(617,30,175,699,'2025-05-12 13:00:15'),(618,30,177,706,'2025-05-12 13:00:15'),(619,30,174,694,'2025-05-12 13:00:15'),(620,30,176,703,'2025-05-12 13:00:15');
/*!40000 ALTER TABLE `student_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `student_exams`
--

DROP TABLE IF EXISTS `student_exams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `student_exams` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` int NOT NULL,
  `exam_id` int NOT NULL,
  `status` enum('assigned','completed') COLLATE utf8mb4_general_ci DEFAULT 'assigned',
  `start_time` datetime DEFAULT NULL,
  `assigned_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed_at` timestamp NULL DEFAULT NULL,
  `attempts` int NOT NULL,
  `result_approved` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_student_exam` (`student_id`,`exam_id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `student_exams_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `student_exams_ibfk_2` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `student_exams`
--

LOCK TABLES `student_exams` WRITE;
/*!40000 ALTER TABLE `student_exams` DISABLE KEYS */;
INSERT INTO `student_exams` (`id`, `student_id`, `exam_id`, `status`, `start_time`, `assigned_at`, `completed_at`, `attempts`, `result_approved`) VALUES (35,18,11,'completed',NULL,'2025-05-01 04:56:21','2025-05-11 17:45:35',2,0),(52,30,11,'completed','2025-05-05 10:47:04','2025-05-05 10:43:00','2025-05-12 13:00:15',24,1),(53,31,11,'completed','2025-05-05 10:47:59','2025-05-05 10:45:12','2025-05-12 07:36:39',9,1),(54,32,11,'completed','2025-05-05 10:47:30','2025-05-05 10:45:12','2025-05-12 07:31:11',6,1),(55,35,11,'completed',NULL,'2025-05-06 11:11:31','2025-05-07 05:28:52',1,1),(56,34,11,'completed',NULL,'2025-05-06 11:11:32','2025-05-07 05:41:21',17,1),(57,33,11,'completed',NULL,'2025-05-06 11:11:32','2025-05-12 07:40:09',2,1),(59,18,12,'assigned',NULL,'2025-05-07 16:14:33',NULL,0,1),(60,18,13,'assigned',NULL,'2025-05-12 15:42:29',NULL,0,0),(61,18,14,'assigned',NULL,'2025-05-12 15:44:09',NULL,0,0),(62,18,15,'assigned',NULL,'2025-05-12 15:46:30',NULL,0,0);
/*!40000 ALTER TABLE `student_exams` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `students`
--

DROP TABLE IF EXISTS `students`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `students` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `password_hash` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `attempts_allowed` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `student_id` (`student_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `students`
--

LOCK TABLES `students` WRITE;
/*!40000 ALTER TABLE `students` DISABLE KEYS */;
INSERT INTO `students` (`id`, `student_id`, `name`, `password_hash`, `attempts_allowed`) VALUES (18,'admingaurav','Gaurav','',0),(30,'test','Guest','',1),(31,'test2','Guest','',1),(32,'test1','Guest','',1),(33,'test3','Guest','',1),(34,'test4','Guest','',1),(35,'test5','Guest','',1);
/*!40000 ALTER TABLE `students` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'youthpdo_students_exams'
--

--
-- Dumping routines for database 'youthpdo_students_exams'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-05-12 15:51:30
