<?php
session_start();
if (!isset($_SESSION['student_id'])) {
    header('Location: student_login.php');
    exit;
}

$student_id = $_SESSION['student_id'];

require_once 'connectiondb.php';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Fetch completed exams for the student
    $stmt = $pdo->prepare("
        SELECT e.id, e.exam_name
        FROM exams e
        JOIN student_exams se ON e.id = se.exam_id
        WHERE se.student_id = ? AND se.status = 'completed' AND se.result_approved = 1
        ORDER BY e.exam_name
    ");
    $stmt->execute([$student_id]);
    $completed_exams = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}

function calculate_score($pdo, $student_id, $exam_id) {
    // Get total questions count
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM questions WHERE exam_id = ?");
    $stmt->execute([$exam_id]);
    $total_questions = (int)$stmt->fetchColumn();

    if ($total_questions === 0) {
        return [0, 0];
    }

    // Get count of correct answers by comparing selected_option_id with correct option
    $stmt = $pdo->prepare("
        SELECT COUNT(*) FROM student_answers sa
        JOIN questions q ON sa.question_id = q.id
        JOIN options o ON sa.selected_option_id = o.id
        WHERE sa.student_id = ? AND q.exam_id = ? AND o.is_correct = 1
    ");
    $stmt->execute([$student_id, $exam_id]);
    $correct_answers = (int)$stmt->fetchColumn();

    return [$correct_answers, $total_questions];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Student Results</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <a class="navbar-brand" href="student_dashboard.php">MCQ Exam Portal</a>
    <div class="d-flex align-items-center">
      <a href="student_logout.php" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>
<div class="container my-4">
    <h2 class="mb-4">Your Exam Results</h2>
    <?php if (empty($completed_exams)): ?>
        <p>You have not completed any exams yet.</p>
    <?php else: ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Exam Name</th>
                    <th>Total Questions</th>
                    <th>Correct Answers</th>
                    <th>Score (%)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($completed_exams as $exam): 
                    list($correct, $total) = calculate_score($pdo, $student_id, $exam['id']);
                    $percentage = $total > 0 ? round(($correct / $total) * 100, 2) : 0;
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                    <td><?php echo $total; ?></td>
                    <td><?php echo $correct; ?></td>
                    <td><?php echo $percentage; ?>%</td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
</body>
</html>
