<?php
session_start();
if(!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true){
    header('Location: admin_login.php');
    exit;
}

require_once 'connectiondb.php';

$exam_id = $_GET['exam_id'] ?? '';
if(empty($exam_id) || !is_numeric($exam_id)){
    die("Invalid exam ID.");
}

// Handle transfer student POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['transfer_student'])) {
        $student_id = $_POST['student_id'] ?? '';
        $new_exam_id = $_POST['new_exam_id'] ?? '';
        if (!empty($student_id) && !empty($new_exam_id) && is_numeric($student_id) && is_numeric($new_exam_id)) {
            // Check if student already assigned to new exam
            $stmtCheck = $pdo->prepare("SELECT id FROM student_exams WHERE student_id = ? AND exam_id = ?");
            $stmtCheck->execute([$student_id, $new_exam_id]);
            if ($stmtCheck->fetch()) {
                $transfer_error = "Student is already assigned to the selected exam.";
            } else {
                // Update student_exams to new exam
                $stmtUpdate = $pdo->prepare("UPDATE student_exams SET exam_id = ?, status = 'assigned', completed_at = NULL WHERE student_id = ? AND exam_id = ?");
                $stmtUpdate->execute([$new_exam_id, $student_id, $exam_id]);
                $transfer_success = "Student transferred successfully.";
            }
        } else {
            $transfer_error = "Invalid student or exam selection.";
        }
    } elseif (isset($_POST['remove_student'])) {
        $student_id = $_POST['student_id'] ?? '';
        if (!empty($student_id) && is_numeric($student_id)) {
            // Delete student exam assignment
            $stmtDelete = $pdo->prepare("DELETE FROM student_exams WHERE student_id = ? AND exam_id = ?");
            $stmtDelete->execute([$student_id, $exam_id]);
            if ($stmtDelete->rowCount() > 0) {
                $remove_success = "Student removed from exam successfully.";
            } else {
                $remove_error = "Failed to remove student from exam.";
            }
        } else {
            $remove_error = "Invalid student selection.";
        }
    }
}

// Fetch exam details
$stmt = $pdo->prepare("SELECT * FROM exams WHERE id = ?");
$stmt->execute([$exam_id]);
$exam = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$exam){
    die("Exam not found.");
}

$stmt = $pdo->prepare("
    SELECT s.id AS student_id, s.student_id AS student_code, s.name, se.status, se.completed_at, se.start_time
    FROM student_exams se
    JOIN students s ON se.student_id = s.id
    WHERE se.exam_id = ?
    ORDER BY s.name
");
$stmt->execute([$exam_id]);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Exam Students - <?php echo htmlspecialchars($exam['exam_name']); ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
</head>
<body>
<?php include 'navbar.php'; ?>
<div class="container my-4">
    <h2>Students Assigned to Exam: <?php echo htmlspecialchars($exam['exam_name']); ?></h2>
    <a href="edit_exam.php?exam_id=<?php echo $exam['id']; ?>" class="btn btn-primary mb-3">Edit Exam</a>
    <?php if (!empty($transfer_error)): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($transfer_error); ?></div>
    <?php endif; ?>
    <?php if (!empty($transfer_success)): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($transfer_success); ?></div>
    <?php endif; ?>
    <?php if(empty($students)): ?>
        <p>No students assigned to this exam.</p>
    <?php else: ?>
        <?php
        // Fetch all exams for transfer dropdown
        $stmt2 = $pdo->query("SELECT id, exam_name FROM exams ORDER BY exam_name");
        $all_exams = $stmt2->fetchAll(PDO::FETCH_ASSOC);
        ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Student Code</th>
                    <th>Name</th>
                    <th>Status</th>
                    <th>Completed At</th>
                    <th>Transfer to Exam</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($students as $student): ?>
                <tr>
                    <td><?php echo htmlspecialchars($student['student_code']); ?></td>
                    <td><?php echo htmlspecialchars($student['name']); ?></td>
                    <td><?php echo htmlspecialchars($student['status']); ?></td>
                    <td><?php echo htmlspecialchars($student['completed_at']); ?></td>
                    <td>
                        <?php
                        if (!empty($student['start_time']) && !empty($student['completed_at'])) {
                            $start_dt = new DateTime($student['start_time']);
                            $completed_dt = new DateTime($student['completed_at']);
                            $interval = $start_dt->diff($completed_dt);
                            echo $interval->format('%h hours %i minutes %s seconds');
                        } else {
                            echo 'N/A';
                        }
                        ?>
                    </td>
                    <td>
                        <form method="POST" action="admin_exam_students.php?exam_id=<?php echo $exam['id']; ?>" onsubmit="return confirm('Are you sure you want to transfer this student to the selected exam?');">
                            <input type="hidden" name="student_id" value="<?php echo htmlspecialchars($student['student_id']); ?>">
                            <select name="new_exam_id" class="form-select form-select-sm" required>
                                <option value="">Select Exam</option>
                                <?php foreach($all_exams as $ex): ?>
                                    <?php if($ex['id'] != $exam['id']): ?>
                                    <option value="<?php echo $ex['id']; ?>"><?php echo htmlspecialchars($ex['exam_name']); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <button type="submit" name="transfer_student" class="btn btn-sm btn-warning mt-1">Transfer</button>
                        </form>
                    </td>
                    <td>
                        <a href="view_student_responses.php?student_id=<?php echo urlencode($student['student_id']); ?>&exam_id=<?php echo urlencode($exam['id']); ?>" class="btn btn-sm btn-info">View Responses</a>
                        <a href="view_student_responses.php?student_id=<?php echo urlencode($student['student_id']); ?>&exam_id=<?php echo urlencode($exam['id']); ?>&print=1" target="_blank" class="btn btn-sm btn-primary ms-1">Print Responses</a>
                        <form method="POST" action="admin_exam_students.php?exam_id=<?php echo $exam['id']; ?>" style="display:inline-block;" onsubmit="return confirm('Are you sure you want to remove this student from the exam?');">
                            <input type="hidden" name="student_id" value="<?php echo htmlspecialchars($student['student_id']); ?>">
                            <button type="submit" name="remove_student" class="btn btn-sm btn-danger ms-1">Remove</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
    <a href="admin_dashboard.php" class="btn btn-secondary mt-3">Back to Dashboard</a>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
