<?php
session_start();

// Database connection
require_once 'connectiondb.php';


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_id = $_POST['student_id'] ?? '';
    $exam_code = $_POST['exam_code'] ?? '';

    if (empty($student_id) || empty($exam_code)) {
        $error = "Please enter both Student ID and Exam Code.";
    } else {
        // Check if student exists
        $stmt = $pdo->prepare("SELECT * FROM students WHERE student_ID = ?");
        $stmt->execute([$student_id]);
        $student = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$student) {
            $error = "Invalid Student ID.";
        } else {
            // Check if exam exists
            $stmt = $pdo->prepare("SELECT * FROM exams WHERE exam_code = ?");
            $stmt->execute([$exam_code]);
            $exam = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$exam) {
                $error = "Invalid Exam Code.";
            } else {
                // Set session and redirect to student dashboard
                $_SESSION['student_id'] = $student['id'];
                header('Location: student_dashboard.php');
                exit;
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Student Login - MCQ Exam Portal</title>
    <style>
        /* Reset some default styles */
        * {
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;

            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #333;
        }
        .login-container {
            background: #fff;
            padding: 2.5rem 3rem;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        h2 {
            margin-bottom: 1.5rem;
            color: #222;
            font-weight: 700;
            font-size: 1.8rem;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 1.25rem;
        }
        label {
            font-weight: 600;
            text-align: left;
            color: #555;
        }
        input[type="text"] {
            padding: 0.75rem 1rem;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
            transition: border-color 0.3s ease;
        }
        input[type="text"]:focus {
            border-color: #2575fc;
            outline: none;
            box-shadow: 0 0 8px rgba(37, 117, 252, 0.4);
        }
        button {
            padding: 0.85rem 1rem;
            background-color: #2575fc;
            color: white;
            font-size: 1.1rem;
            font-weight: 700;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #1a54c8;
        }
        .error-message {
            color: #d93025;
            background-color: #fce8e6;
            border: 1px solid #d93025;
            padding: 0.75rem 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            font-weight: 600;
            text-align: left;
        }
        @media (max-width: 480px) {
            .login-container {
                padding: 2rem 1.5rem;
                margin: 0 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Student Login</h2>
        <?php if (!empty($error)) { echo "<div class='error-message'>$error</div>"; } ?>
        <form method="POST" action="student_login.php" novalidate>
            <label for="student_id">Student ID:</label>
            <input type="text" id="student_id" name="student_id" required autocomplete="off" />
            <label for="exam_code">Exam Code:</label>
            <input type="text" id="exam_code" name="exam_code" required autocomplete="off" />
            <button type="submit">Login</button>
    </form>
</body>
</html>

